<html>
<head>
    <title> {{__('Authorized.net Payment Gateway')}}</title>
    <style>
        *{
            margin: 0;
            padding: 0;
        }
        .autorize-payment-wrapper{
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100%;
        }
        .autorize-payment-inner-wrapper {
            max-width: 600px;
            box-shadow: 0 0 40px 0 rgba(0,0,0,0.05);
            border-radius: 10px;
            padding: 30px 40px 30px;
        }

        .autorize-payment-inner-wrapper .logo-wrapper img {
            max-width: 200px;
            margin: 0 auto;
        }

        .autorize-payment-inner-wrapper .logo-wrapper {
            text-align: center;
            margin-bottom: 40px;
        }
        .form-group {
            margin-bottom: 15px;
        }

        .form-group label {
            display: block;
            font-size: 16px;
            line-height: 20px;
            margin-bottom: 5px;
        }

        div#cc-form {
            margin-top: 30px;
        }

        .form-group input {
            height: 30px;
            border: 1px solid #f2f2f2;
            border-radius: 5px;
            padding: 5px 10px;
            display: block;
            width: 100%;
        }
        .cardinfo_wrap {
            display: flex;
            justify-content: space-between;
        }
        .btn-wrapper {
            display: block;
            text-align: center;
        }

        .btn-wrapper button {
            border: none;
            padding: 15px 25px;
            display: inline-block;
            border-radius: 5px;
            margin-top: 30px;
            background-color: #333;
            color: #fff;
            transition: all 300ms;
            cursor: pointer;
        }
        .btn-wrapper button:hover{
            opacity: .8;
        }
    </style>
</head>
<body>
<div class="autorize-payment-wrapper">
    <div class="autorize-payment-inner-wrapper">
        <div class="logo-wrapper">
            <img src="data:image/png;base64,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" alt="">
        </div>
        <div class='card-wrapper'></div>
        <form id="stripe_form" method="post" action="{{route('xg.payment.gateway.authorizenet')}}">
            @csrf
            @foreach($authorizenet_data as $field_name => $value)
                <input type="hidden" name="{{$field_name}}"  value="{{$value}}"/>
            @endforeach
                <div id="cc-form">
                    <div class="form-group">
                        <label>{{__('Card Number')}}</label>
                        <input type="text" name="number" placeholder="{{__("card number")}}">
                    </div>
                    <div class="form-group">
                        <label>{{__('Full Name')}}</label>
                        <input type="text" name="name" placeholder="{{__("full name")}}"/>
                    </div>
                    <div class="cardinfo_wrap">
                        <div class="form-group">
                            <label>{{__('Expiry')}}</label>
                            <input type="text" name="expiry" placeholder="{{__("expiry")}}"/>
                        </div>
                        <div class="form-group">
                            <label>{{__('CVC')}}</label>
                            <input type="text" name="cvc" placeholder="{{__("cvc")}}"/>
                        </div>
                    </div>
                </div>
            <div class="btn-wrapper">
                <button type="submit">{{__('Pay')}} {{$authorizenet_data['charge_amount'].''.$authorizenet_data['currency']}}</button>
            </div>
        </form>

    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/card/2.5.4/card.js" integrity="sha512-lIdTIGaSjFWSxmWDSyKbLz1OJ3c1o4Vm6FXRguKH1HzOVCRSF8Ypg30+yga7j5TUMh4Sf5iFvC9/NQQr1KumQg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>

<script>
    var card = new Card({
        form: '#cc-form',
        container: '.card-wrapper',

        formSelectors: {
            nameInput: 'input[name="name"]'
        }
    });
</script>
</body>
</html>
