<?php

declare(strict_types=1);

namespace Square\Models;

use stdClass;

class DestinationDetailsCardRefundDetails implements \JsonSerializable
{
    /**
     * @var Card|null
     */
    private $card;

    /**
     * @var array
     */
    private $entryMethod = [];

    /**
     * @var array
     */
    private $authResultCode = [];

    /**
     * Returns Card.
     * Represents the payment details of a card to be used for payments. These
     * details are determined by the payment token generated by Web Payments SDK.
     */
    public function getCard(): ?Card
    {
        return $this->card;
    }

    /**
     * Sets Card.
     * Represents the payment details of a card to be used for payments. These
     * details are determined by the payment token generated by Web Payments SDK.
     *
     * @maps card
     */
    public function setCard(?Card $card): void
    {
        $this->card = $card;
    }

    /**
     * Returns Entry Method.
     * The method used to enter the card's details for the refund. The method can be
     * `KEYED`, `SWIPED`, `EMV`, `ON_FILE`, or `CONTACTLESS`.
     */
    public function getEntryMethod(): ?string
    {
        if (count($this->entryMethod) == 0) {
            return null;
        }
        return $this->entryMethod['value'];
    }

    /**
     * Sets Entry Method.
     * The method used to enter the card's details for the refund. The method can be
     * `KEYED`, `SWIPED`, `EMV`, `ON_FILE`, or `CONTACTLESS`.
     *
     * @maps entry_method
     */
    public function setEntryMethod(?string $entryMethod): void
    {
        $this->entryMethod['value'] = $entryMethod;
    }

    /**
     * Unsets Entry Method.
     * The method used to enter the card's details for the refund. The method can be
     * `KEYED`, `SWIPED`, `EMV`, `ON_FILE`, or `CONTACTLESS`.
     */
    public function unsetEntryMethod(): void
    {
        $this->entryMethod = [];
    }

    /**
     * Returns Auth Result Code.
     * The authorization code provided by the issuer when a refund is approved.
     */
    public function getAuthResultCode(): ?string
    {
        if (count($this->authResultCode) == 0) {
            return null;
        }
        return $this->authResultCode['value'];
    }

    /**
     * Sets Auth Result Code.
     * The authorization code provided by the issuer when a refund is approved.
     *
     * @maps auth_result_code
     */
    public function setAuthResultCode(?string $authResultCode): void
    {
        $this->authResultCode['value'] = $authResultCode;
    }

    /**
     * Unsets Auth Result Code.
     * The authorization code provided by the issuer when a refund is approved.
     */
    public function unsetAuthResultCode(): void
    {
        $this->authResultCode = [];
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->card)) {
            $json['card']             = $this->card;
        }
        if (!empty($this->entryMethod)) {
            $json['entry_method']     = $this->entryMethod['value'];
        }
        if (!empty($this->authResultCode)) {
            $json['auth_result_code'] = $this->authResultCode['value'];
        }
        $json = array_filter($json, function ($val) {
            return $val !== null;
        });

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
